% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.cv.glmnetr_240322.R
\name{summary.cv.glmnetr}
\alias{summary.cv.glmnetr}
\title{Output summary of a cv.glmnetr() output object.}
\usage{
\method{summary}{cv.glmnetr}(object, printg1 = "FALSE", orderall = FALSE, ...)
}
\arguments{
\item{object}{a cv.glmnetr() output object.}

\item{printg1}{TRUE to also print out the fully penalized lasso beta, else FALSE to suppress.}

\item{orderall}{By default (orderall=FALSE) the order terms enter into the lasso model 
is given for the number of terms that enter in lasso minimizing loss model.  If 
orderall=TRUE then all terms that are included in any lasso fit are described.}

\item{...}{Additional arguments passed to the summary function.}
}
\value{
Coefficient estimates (beta)
}
\description{
Summarize the cross-validation informed model fit.  The fully penalized
(gamma=1) beta estimate will not be given by default but can too be output  
using printg1=TRUE.
}
\examples{
# set seed for random numbers, optionally, to get reproducible results
set.seed(82545037)
sim.data=glmnetr.simdata(nrows=100, ncols=100, beta=NULL)
xs=sim.data$xs 
y_=sim.data$y_ 
event=sim.data$event
# for this example we use a small number for folds_n to shorten run time 
cv.glmnetr.fit = cv.glmnetr(xs, NULL, y_, NULL, family="gaussian", folds_n=3, limit=2) 
summary(cv.glmnetr.fit)

}
\seealso{
\code{\link{predict.cv.glmnetr}} , \code{\link{cv.glmnetr}} , \code{\link{nested.glmnetr}}
}
