% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_glmtlp.R
\name{plot.glmtlp}
\alias{plot.glmtlp}
\title{plot solution path from a "glmtlp" object.}
\usage{
\method{plot}{glmtlp}(
  x,
  xvar = c("lambda", "kappa", "deviance", "l1_norm", "log_lambda", "log_kappa"),
  xlab = iname,
  ylab = "Coefficients",
  title = "Solution Path",
  label = FALSE,
  label.size = 3,
  ...
)
}
\arguments{
\item{x}{Fitted \code{"glmtlp"} model object.}

\item{xvar}{the x-axis variable to plot against, including \code{"lambda"}, 
\code{"kappa"}, \code{"deviance"}, \code{"l1_norm"}, and \code{"log_lambda"}.}

\item{xlab}{the x-axis label of the plot, default is "Lambda", "Kappa", 
"Fraction of Explained Deviance", "L1 Norm",  and "Log Lambda".}

\item{ylab}{the y-axis label of the plot, default is "Coefficients".}

\item{title}{the main title of the plot, default is "Solution Path".}

\item{label}{logical, whether or not attach the labels for the non-zero 
coefficients, default is FALSE.}

\item{label.size}{the text size of the labels, default is 3.}

\item{\dots}{Additional arguments.}
}
\value{
A \code{ggplot} object.
}
\description{
this function generates a solution path plot from a fitted \code{"glmtlp"} object.
}
\examples{
X <- matrix(rnorm(100 * 20), 100, 20)
y <- rnorm(100)
fit <- glmtlp(X, y, family = "gaussian", penalty = "l1")
plot(fit, xvar = "lambda")
plot(fit, xvar = "log_lambda")
plot(fit, xvar = "l1_norm")
plot(fit, xvar = "log_lambda", label = TRUE)
fit2 <- glmtlp(X, y, family = "gaussian", penalty = "l0")
plot(fit2, xvar = "kappa", label = TRUE)

}
\references{
Shen, X., Pan, W., & Zhu, Y. (2012). 
  \emph{Likelihood-based selection and sharp parameter estimation. 
  Journal of the American Statistical Association, 107(497), 223-232.}
  \cr Yang, Y., & Zou, H. (2014). \emph{A coordinate majorization descent algorithm 
  for l1 penalized learning. Journal of Statistical Computation and 
  Simulation, 84(1), 84-95.}
  \cr Two R package Github: \emph{ncvreg} and \emph{glmnet}.
}
\seealso{
\code{print}, \code{predict}, \code{coef} and \code{plot} methods,
and the \code{cv.glmtlp} function.
}
\author{
Chunlin Li, Yu Yang, Chong Wu 
  \cr Maintainer: Yu Yang \email{yang6367@umn.edu}
}
\keyword{models}
\keyword{plot}
