% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gau_data}
\alias{gau_data}
\title{A simulated gaussian data set.}
\format{
A list with five elements: design matrix \code{X}, response \code{y}, 
  correlation structure of the covariates \code{Sigma}, true beta \code{beta}, 
  and the noise level \code{sigma}.
\describe{
  \item{X}{design matrix}
  \item{y}{response}
  \item{beta}{true beta values}
  \item{sigma}{the noise level}
}
}
\usage{
data(gau_data)
}
\description{
A data set simulated for illustrating linear regression models. Generated by 
  \code{gen.gaussian.data(n = 200, p = 20, seed = 2021)}.
}
\examples{
data("gau_data")
cv.fit <- cv.glmtlp(gau_data$X, gau_data$y, family = "gaussian", penalty = "tlp")
plot(cv.fit)

}
\keyword{datasets}
