% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalsByName.R
\name{globalsByName}
\alias{globalsByName}
\title{Locates and retrieves a set of global variables by their names}
\usage{
globalsByName(names, envir = parent.frame(), mustExist = TRUE, ...)
}
\arguments{
\item{names}{A character vector of global variable names.}

\item{envir}{The environment from where to search for globals.}

\item{mustExist}{If TRUE, an error is thrown if the object of the
identified global cannot be located.  Otherwise, the global
is not returned.}

\item{\ldots}{Not used.}
}
\value{
A \link{Globals} object of named elements and an attribute
\code{where} with named elements. Both of sets have names according to
\code{names}.
}
\description{
Locates and retrieves a set of global variables by their names
}
\section{Special "argument" globals}{

If \code{names} specifies \code{"..."}, \code{"..1"},  \code{"..2"}, ..., then they
are interpreted as arguments \code{...}, \code{..1}, \code{..2}, ..., respectively.
If specified, then the corresponding elements in the results are
lists of class \code{DotDotDotList} comprising the value of the latter.
If the special argument does not exist, then the value is \code{NA}, and
the corresponding \code{where} attributes is \code{NULL}.
}

\examples{
f <- function(x = 42, ...) {
  globalsByName("x")
}

globals <- f()
str(globals)

globals <- f(3.14)
str(globals)


g <- function(x = 42, ...) {
  globalsByName("...")
}

globals <- g()
str(globals)

globals <- g(3.14)
str(globals)

globals <- g(3.14, 1L, b = 2L, c = 3L)
str(globals)


h <- function(x = 42, ...) {
  globalsByName("..2")
}

globals <- h(x = 3.14, a = 1, b = 2)
str(globals)

globals <- g(3.14)
str(globals)

globals <- g(3.14, 1L, b = 2L, c = 3L)
str(globals)
}
