% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globpso.R
\name{getPSOInfo}
\alias{getPSOInfo}
\title{Generation function of PSO parameter settings}
\usage{
getPSOInfo(
  nSwarm = 32,
  maxIter = 100,
  psoType = "basic",
  freeRun = 1,
  tol = 1e-06,
  c1 = 2.05,
  c2 = 2.05,
  w0 = 1.2,
  w1 = 0.2,
  w_var = 0.8,
  vk = 4,
  Q_cen_type = 1,
  Q_a0 = 1.7,
  Q_a1 = 0.7,
  Q_a_var = 0.8,
  LcRi_L = 0.01,
  CSO_phi = 0.1,
  TE_b = 2
)
}
\arguments{
\item{nSwarm}{A integer number of swarm size in PSO algorithm.}

\item{maxIter}{A integer number of maximal PSO iterations.}

\item{psoType}{string. The type of PSO. This package current supports the following types:
\describe{
\item{"basic"}{ Linearly Decreasing Weight PSO (Eberhart & Kennedy, 1995)}
\item{"quantum"}{ Quantum PSO (Sun et al., 2004)}
\item{"lcri"}{ LcRiPSO (Bonyadi & Michalewicz, 2014)}
\item{"comp"}{ Competitive Swarm Optimization (Cheng & Jin, 2014)}
\item{"dexp"}{ DExPSO (Stehlík et al., 2024)}
}}

\item{freeRun}{A number between \eqn{[0,1]} that controls the percentage of PSO iterations which are free from examining the
stopping criterion, \eqn{|f'-f|<\varepsilon}
where \eqn{f'} and \eqn{f} are the objective function values in the previous and current iterations, respectively.
The default is 1.0 implying the PSO will completely ignore the stopping criterion.
Otherwise, the PSO checks the stopping criterion after free iterations.}

\item{tol}{A small value for the tolerance, \eqn{\varepsilon}, in the stopping criterion.
For \code{freeRun} smaller than 1.0, the default is \code{1e-6}. Otherwise, this value would not affect the algorithm.}

\item{c1}{The value of cognitive parameter in PSO updating procedure. The default is 2.05.}

\item{c2}{The value of social parameter in PSO updating procedure. The default is 2.05.}

\item{w0}{The value of starting inertia weight in PSO updating procedure. The default is 1.2.}

\item{w1}{The value of ending inertia weight in PSO updating procedure. The default is 0.2.}

\item{w_var}{A number between \eqn{[0,1]} that controls the percentage of iterations that PSO linearly decreases the inertia weight
from \code{w0} to \code{w1}. The default is 0.8.}

\item{vk}{The value of velocity clamping parameter. The default is 4.}

\item{Q_cen_type}{The type of the center position in QPSO updating procedure (\code{0}: local attractor, default; \code{1}: mean best).}

\item{Q_a0}{The value of starting contraction-expansion (CE) coefficient in QPSO updating procedure. The default is 1.7.}

\item{Q_a1}{The value of ending contraction-expansion (CE) coefficient in QPSO updating procedure. The default is 0.7.}

\item{Q_a_var}{A number between \eqn{[0,1]} that controls the percentage of iterations that QPSO linearly decreases the CE coefficient
from \code{Q_a0} to \code{Q_a1}. The default is 0.8.}

\item{LcRi_L}{The value of random number generator based on normal density social parameter in LcRiPSO updating procedure. The default is 0.01. (for \code{psoType = c("lcri")} only)}

\item{CSO_phi}{The value of social parameter in CSO updating procedure. The default is 0.1. (for \code{psoType = c("comp", "cdexp")} only)}

\item{TE_b}{The value of random number generator based on double-exponential density. The default is 2.0. (for \code{psoType = c("dexp", "qdexp", "cdexp")} only).}
}
\value{
A list of PSO parameter settings.
}
\description{
Create a list with PSO parameters for Minimization.
}
\examples{
PSO_INFO <- getPSOInfo(nSwarm = 32, maxIter = 100)
}
