% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glottocheck.R
\name{glottocheck}
\alias{glottocheck}
\title{Quality check of glottodata or glottosubdata}
\usage{
glottocheck(glottodata, diagnostic = TRUE, checkmeta = FALSE)
}
\arguments{
\item{glottodata}{User-provided glottodata}

\item{diagnostic}{If TRUE (default) a data viewer will be opened to show the levels of each variable (including NAs), and a data coverage plot will be shown.}

\item{checkmeta}{Should metadata be checked as well?}
}
\value{
Diagnostic messages highlighting potential issues with glottodata or glottosubdata.
}
\description{
This function first checks whether a dataset is glottodata or glottosubdata, and depending on the result calls glottocheck_data or glottocheck_subdata.
}
\details{
It subsequently checks whether:
\itemize{
  \item one column exists with the name "glottocode"
  \item there are rows without a glottocode  (missing IDs)
  \item there are rows with duplicated glottocodes (duplicate IDs)
  \item all variables have at least two levels
  \item all glottocodes are valid
}
}
\examples{
\donttest{
glottodata <- glottoget("demodata")
glottocheck(glottodata, diagnostic = FALSE)
}
}
\concept{<glottocheck>}
