% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md-inlines.R
\name{md_code}
\alias{md_code}
\title{Markdown code span}
\usage{
md_code(x)
}
\arguments{
\item{x}{The text to be formatted as fixed-width inline code.}
}
\value{
A \code{glue} vector of length equal to \code{x}.
}
\description{
Take a character vector and wrap each element in backticks to create a glue
vector of inline code spans. This inline is rendered as a \verb{<code>} HTML tag.
}
\details{
A backtick string is a string of one or more backtick characters that is
neither preceded nor followed by a backtick.

A code span begins with a backtick string and ends with a backtick string
of equal length. The contents of the code span are the characters between
the two backtick strings, normalized in the following ways: * First, line
endings are converted to spaces. * If the resulting string both begins and
ends with a space character, but does not consist entirely of space
characters, a single space character is removed from the front and back.
This allows you to include code that begins or ends with backtick
characters, which must be separated by whitespace from the opening or
closing backtick strings.
}
\examples{
md_code("ex_var")
md_code(state.name[1:3])
}
\seealso{
Other inline functions: 
\code{\link{md_autolink}()},
\code{\link{md_bold}()},
\code{\link{md_convert}()},
\code{\link{md_disallow}()},
\code{\link{md_escape}()},
\code{\link{md_hardline}()},
\code{\link{md_image}()},
\code{\link{md_issue}()},
\code{\link{md_italic}()},
\code{\link{md_link}()},
\code{\link{md_softline}()},
\code{\link{md_strike}()},
\code{\link{md_text}()}
}
\concept{inline functions}
