% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derived.traits.R
\name{phdt}
\alias{phdt}
\title{Derived traits for Glycan peaks in PLASMA for HPLC}
\usage{
phdt(data = NULL, method = "2011", print.exp.names = FALSE)
}
\arguments{
\item{data}{data frame that holds columns representing Glycans.
These column names should start with 'GP'.}

\item{method}{year of the derived traits definition. By default 2011.}

\item{print.exp.names}{If \code{TRUE} return expected column names 
representing glycans.}
}
\value{
Returns the data frame with derived traits
}
\description{
Calculates values of derived traits for Glycan peaks in Plasma for HPLC
}
\details{
Calculates derived traits from basic glycan peaks. User can choose
which definition of the derived traits he will use
(see references for different versions/definitions of derived traits).
}
\references{
Lu et al. (2011)
"Screening Novel Biomarkers for Metabolic Syndrome by Profiling 
 Human Plasma N-Glycans in Chinese Han and Croatian Populations"
\doi{10.1021/pr2004067}
Irena Trbojevic-Akmacic et al.
"Plasma N-glycome composition associates with chronic low back pain"
\doi{10.1016/j.bbagen.2018.07.003}
}
\author{
Ivo Ugrina, Lucija Klarić
}
