% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploratools.R
\name{pairsmap}
\alias{pairsmap}
\alias{pairsmap.SpatialPointsDataFrame}
\alias{pairsmap.default}
\title{Multiple maps
Matrix of maps showing different combinations of components of a composition, user defined}
\usage{
pairsmap(data, ...)

\method{pairsmap}{SpatialPointsDataFrame}(data, ...)

\method{pairsmap}{default}(
  data,
  loc,
  colscale = rev(rainbow(10, start = 0, end = 4/6)),
  cexrange = c(0.1, 2),
  scale = rank,
  commonscale = FALSE,
  mfrow = c(floor(sqrt(ncol(data))), ceiling(ncol(data)/floor(sqrt(ncol(data))))),
  foregroundcolor = "black",
  closeplot = TRUE,
  ...
)
}
\arguments{
\item{data}{data to represent; admits many data containing objects
(matrix, data.frame, classes from package \code{compositions}) as well
as their \code{Spatial} counterparts (in which case, \code{loc} is not necessary)}

\item{...}{extra arguments for generic functionality}

\item{loc}{matrix or data.frame of coordinates of the sample locations}

\item{colscale}{set of colors to be used as colorscale (defauls to 10 colors between blue and red)}

\item{cexrange}{symbol size min and max values (default to 0.1 to 2)}

\item{scale}{function scaling the set of z-values of each map, defaults to \code{\link{rank}}}

\item{commonscale}{logical, should all plots share a common z-scale? defaults to FALSE}

\item{mfrow}{vector of two integers, giving the number of plots per row and per column of the
matrix of plots to be created; defaults to something square-ish, somewhat wider than longer, and able to
contain all plots}

\item{foregroundcolor}{color to be used for the border of the symbol}

\item{closeplot}{logical, should the plot be left open (FALSE) for further changes, or be frozen (TRUE)?
defaults to TRUE}
}
\value{
The function is primarily called for producing a matrix of plots of each component of a
multivariate data set, such as a compositional data set. Each plot represents a map whose symbols
are colored and sized according to a z-scale controlled by one of the variables of the data set.
It can be used virtually with any geometry, any kind of data (compositional, positive, raw, etc).
This function returns invisibly the graphical parameters that were active prior to calling this
function. This allows the user to add further stuff to the plots (mostly, using \code{par(mfg=c(i,j))}
to plot on the diagram (i,j)), or else freeze the plot (by wrapping the call to \code{pwlrmap}
on a call to \code{\link{par}}).
}
\description{
Multiple maps
Matrix of maps showing different combinations of components of a composition, user defined
}
\section{Methods (by class)}{
\itemize{
\item \code{SpatialPointsDataFrame}: Multiple maps

\item \code{default}: Multiple maps
}}

\examples{
data("Windarling")
library("compositions")
coords = as.matrix(Windarling[,c("Easting","Northing")])
compo = Windarling[,c("Fe","Al2O3","SiO2", "Mn", "P")]
compo$Rest = 100-rowSums(compo)
compo = acomp(compo)
pairsmap(data=clr(compo), loc=coords) # clr
pairsmap(data=compo, loc=coords) # closed data
}
