% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmSpatialMethodParameters.R
\name{SequentialSimulation}
\alias{SequentialSimulation}
\title{Create a parameter set specifying a gaussian sequential simulation algorithm}
\usage{
SequentialSimulation(nsim = 1, ng = NULL, rank = Inf, debug.level = 1, ...)
}
\arguments{
\item{nsim}{number of realisations desired}

\item{ng}{a neighbourhood specification, as obtained with function \code{\link[=KrigingNeighbourhood]{KrigingNeighbourhood()}}}

\item{rank}{currently ignored (future functionality: obtain a reduced-rank simulation)}

\item{debug.level}{degree of verbosity of results; negative values produce a progress bar; values can be
extracted from \code{\link[gstat:predict.gstat]{gstat::predict.gstat()}}}

\item{...}{further parameters, currently ignored}
}
\value{
an S3-list of class "gmSequentialSimulation" containing the four elements given as arguments
to the function. This is just a compact way to provide further functions such as \link{predict_gmSpatialModel}
with appropriate triggers for choosing a prediction method or another, in this case for triggering
sequential Gaussian simulation.
}
\description{
Create a parameter set describing a sequential simulation algorithm to two-point simulation,
mostly for covariance or variogram-based gaussian random fields.
}
\examples{
data("jura", package="gstat")
X = jura.pred[,1:2]
summary(X)
Zc = jura.pred[,7:10]
ng_local = KrigingNeighbourhood(maxdist=1, nmin=4, omax=5, force=TRUE)
(sgs_local = SequentialSimulation(nsim=100, ng=ng_local, debug.level=-1))
## then run predict(..., pars=sgs_local)
}
