% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variograms.R
\name{as.function.gmCgram}
\alias{as.function.gmCgram}
\alias{predict.gmCgram}
\title{Convert a gmCgram object to an (evaluable) function}
\usage{
\method{as.function}{gmCgram}(x, ...)

\method{predict}{gmCgram}(object, newdata, ...)
}
\arguments{
\item{x}{a gmCgram object}

\item{...}{extra arguments for generic functionality}

\item{object}{gmCgram object}

\item{newdata}{matrix, data.frame or Spatial object containing coordinates}
}
\value{
a \code{function} that can be evaluated normally, with an argument \code{X}
and possibly another argument \code{Y}; both must have the same number of columns
than the geographic dimension of the variogram (i.e. \code{dim(x$M)[3]}).
}
\description{
Evaluate a gmCgram on some h values, or convert the gmCgram object into an evaluable function
}
\section{Functions}{
\itemize{
\item \code{predict.gmCgram}: predict a gmCgram object on some lag vector coordinates
}}

\examples{
utils::data("variogramModels")
v1 = setCgram(type=vg.Gau, sill=diag(2)+0.5, anisRanges = 2*diag(c(3,0.5)))
v2 = setCgram(type=vg.Exp, sill=0.3*diag(2), anisRanges = 0.5*diag(2))
vm = v1+v2
vgf = as.function(vm)
(h = rbind(c(0,1), c(0,0), c(1,1)))
vgf(h)
predict(vm, h)
}
\seealso{
Other gmCgram functions: 
\code{\link{[.gmCgram}()},
\code{\link{[[.gmCgram}()},
\code{\link{as.gmCgram.variogramModelList}()},
\code{\link{length.gmCgram}()},
\code{\link{ndirections}()},
\code{\link{plot.gmCgram}()},
\code{\link{variogramModelPlot}()}
}
\concept{gmCgram functions}
