% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compositionsCompatibility.R
\name{logratioVariogram,acomp-method}
\alias{logratioVariogram,acomp-method}
\title{Logratio variogram of a compositional data}
\usage{
\S4method{logratioVariogram}{acomp}(
  data = comp,
  loc,
  ...,
  azimuth = 0,
  azimuth.tol = 180/length(azimuth),
  comp = NULL
)
}
\arguments{
\item{data}{a data container (of class "gmSpatialModel") or a composition (of class "acomp")}

\item{loc}{if \code{data} is a composition (or if \code{comp} is provided), spatial coordinates of the sampling locations}

\item{...}{extra arguments for generic functionality}

\item{azimuth}{which direction, or directions, are desired (in case of directional variogram)}

\item{azimuth.tol}{which tolerance sould be used for directional variograms?}

\item{comp}{an alias for \code{data}, provided for back-compatibility with compositions::logratioVariogram}
}
\value{
a "logratioVariogram" object, or a "logratioVariogramAnisotropy" object
if you provide more than one \code{azimuth}. See \code{\link[=logratioVariogram]{logratioVariogram()}} for details and
examples.
}
\description{
gmGeostats reimplementation of the compositions::logratioVariogram function
}
