% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploratools.R
\name{swath}
\alias{swath}
\alias{swath.default}
\alias{swath.acomp}
\alias{swath.ccomp}
\alias{swath.rcomp}
\title{Swath plots}
\usage{
swath(data, ...)

\method{swath}{default}(
  data,
  loc,
  pch = ".",
  withLoess = TRUE,
  commonScale = TRUE,
  xlab = deparse(substitute(loc)),
  ...,
  mfrow
)

\method{swath}{acomp}(
  data,
  loc,
  pch = ".",
  withLoess = TRUE,
  commonScale = NA,
  xlab = deparse(substitute(loc)),
  ...
)

\method{swath}{ccomp}(
  data,
  loc,
  pch = ".",
  withLoess = TRUE,
  commonScale = NA,
  xlab = deparse(substitute(loc)),
  ...
)

\method{swath}{rcomp}(
  data,
  loc,
  pch = ".",
  withLoess = TRUE,
  commonScale = NA,
  xlab = deparse(substitute(loc)),
  ...
)
}
\arguments{
\item{data}{data to be represented, compositional class, data.frame, or
spatial data object (in which case, \code{loc} is a formula!)}

\item{...}{further arguments to panel plots}

\item{loc}{a numeric vector with the values for one coordinate}

\item{pch}{symbol to be used for the individual points, defaults to "."}

\item{withLoess}{either logical (should a loess line be added?) or a list
of arguments to DescTools::lines.loess}

\item{commonScale}{logical or NA: should all plots share the same vertical
range? FALSE=no, TRUE=yes (default), for
compositional data sets, the value NA (=all plots within a row) is also
permitted and is actually the default}

\item{xlab}{label for the common x axis (defaults to a deparsed version
of loc)}

\item{mfrow}{distribution of the several plots; it has a good internal default
(not used for compositional
classes)}
}
\value{
Nothing, as the function is primarily called to produce a plot
}
\description{
Plots of data vs. one spatial coordinate, with local average spline curve
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: swath plot default method

\item \code{acomp}: Swath plots for acomp objects

\item \code{ccomp}: Swath plots for ccomp objects

\item \code{rcomp}: Swath plots for rcomp objects
}}

\examples{
\donttest{
data("Windarling")
library("sp")
compo = compositions::acomp(Windarling[,c("Fe","Al2O3","SiO2", "Mn", "P")])
Northing = Windarling$Northing
swath(compo, Northing)
wind.spdf = sp::SpatialPointsDataFrame(sp::SpatialPoints(Windarling[,6:7]), 
     data=compo)
swath(wind.spdf, loc=Northing)
}
}
