% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_arcs.R
\name{remove_arcs}
\alias{remove_arcs}
\title{Remove arcs from a Gaussian mixture graphical model}
\usage{
remove_arcs(gmgm, arcs)
}
\arguments{
\item{gmgm}{An object of class \code{gmbn} or \code{gmdbn}.}

\item{arcs}{A data frame containing the removed arcs. The column \code{from}
describes the start node, the column \code{to} the end node and the column
\code{lag} the time lag between them. Missing values in \code{from} or
\code{to} are interpreted as "all possible nodes", which allows to quickly
define large set of arcs that share common attributes. Missing values in
\code{lag} are replaced by 0. If \code{gmgm} is a \code{gmdbn} object, the
same arcs are removed from each of its \code{gmbn} elements. This constraint
can be overcome by passing a list of data frames named after some of these
elements (\code{b_1}, \dots) and containing arcs specifically removed from
them.}
}
\value{
The \code{gmbn} or \code{gmdbn} object after removing the arcs.
}
\description{
This function removes arcs from a Gaussian mixture graphical model.
}
\examples{
data(gmbn_body)
gmbn_1 <- remove_arcs(gmbn_body,
                      data.frame(from = c("HEIGHT", "AGE"),
                                 to = c("FAT", "WAIST")))

data(gmdbn_air)
gmdbn_1 <- remove_arcs(gmdbn_air,
                       list(b_2 = data.frame(from = c("NO2", "TEMP"),
                                             to = c("O3", "O3"), lag = c(1, 1)),
                            b_13 = data.frame(from = "TEMP", to = "O3",
                                              lag = 1)))

}
\seealso{
\code{\link{add_arcs}}, \code{\link{add_nodes}},
\code{\link{relevant}}, \code{\link{remove_nodes}},
\code{\link{rename_nodes}}
}
