% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_comp.R
\name{merge_comp}
\alias{merge_comp}
\title{Merge mixture components of a Gaussian mixture model}
\usage{
merge_comp(gmm, comp = seq_along(gmm$alpha))
}
\arguments{
\item{gmm}{An object of class \code{gmm}.}

\item{comp}{An integer vector containing the indexes of the merged mixture
components (by default all the components of \code{gmm}).}
}
\value{
The \code{gmm} object after merging the mixture components.
}
\description{
This function merges mixture components of a Gaussian mixture model (Zhang
\emph{et al.}, 2003).
}
\examples{
data(gmm_body)
gmm_1 <- merge_comp(gmm_body, c(1, 2))

}
\references{
Zhang, Z., Chen, C., Sun, J. and Chan, K. L. (2003). EM algorithms for
Gaussian mixtures with split-and-merge operation. \emph{Pattern Recognition},
36(9):1973--1983.
}
\seealso{
\code{\link{split_comp}}
}
