% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglk_full.R
\name{loglk_full}
\alias{loglk_full}
\title{Full log-likelihood function}
\usage{
loglk_full(dat, zm, pi, mu, sigma, xi)
}
\arguments{
\item{dat}{An \eqn{n\times p} matrix where each row represents an individual observation}

\item{zm}{An n-dimensional vector containing the class labels including the missing-label denoted as NA.}

\item{pi}{A g-dimensional vector for the initial values of the mixing proportions.}

\item{mu}{A \eqn{p \times g} matrix for the initial values of the location parameters.}

\item{sigma}{A \eqn{p\times p} covariance matrix,or a list of g covariance matrices with dimension \eqn{p\times p \times g}.
It is assumed to fit the model with a common covariance matrix if \code{sigma} is a \eqn{p\times p} covariance matrix;
otherwise it is assumed to fit the model with unequal covariance matrices.}

\item{xi}{A 2-dimensional vector containing the initial values of the coefficients in the logistic function of the Shannon entropy.}
}
\value{
\item{lk}{Log-likelihood value}
}
\description{
Full log-likelihood function with both terms of ignoring and missing
}
\details{
The full log-likelihood function can be expressed as
\deqn{
\log L_{PC}^{({full})}(\boldsymbol{\Psi})=\log L_{PC}^{({ig})}(\theta)+\log L_{PC}^{({miss})}(\theta,\boldsymbol{\xi}),}
where\eqn{\log L_{PC}^{({ig})}(\theta)}is the log likelihood function formed ignoring the missing in the label of the unclassified features,
and \eqn{\log L_{PC}^{({miss})}(\theta,\boldsymbol{\xi})} is the log likelihood function formed on the basis of the missing-label indicator.
}
