% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMVARconstruction.R
\name{reorder_W_columns}
\alias{reorder_W_columns}
\title{Reorder columns of the W-matrix and lambda parameters of a structural GMVAR model.}
\usage{
reorder_W_columns(gmvar, perm)
}
\arguments{
\item{gmvar}{an object of class \code{'gmvar'} created with \code{fitGMVAR} or \code{GMVAR}.}

\item{perm}{an integer vector of length \eqn{d} specifying the new order of the columns of \eqn{W}.
Also lambda parameters of each regime will be reordered accordingly.}
}
\value{
Returns an object of class \code{'gmvar'} defining a structural GMVAR model with the modified
  structural parameters and constraints.
}
\description{
\code{reorder_W_columns} reorder columns of the W-matrix and lambda parameters
  of a structural GMVAR model.
}
\details{
The order of the columns of \eqn{W} can be changed without changing the implied reduced
  form model as long as the order of lambda parameters is also changed accordingly. Note that the
  constraints imposed on \eqn{W} (or the B-matrix) will also be modified accordingly.

  This function does not support models with constraints imposed on the lambda parameters!

  Also all signs in any column of \eqn{W} can be swapped (without changing the implied reduced form model)
  with the function \code{swap_W_signs} but this obviously also swaps the sign constraints in the
  corresponding columns of \eqn{W}.
}
\examples{
# Structural GMVAR(2, 2), d=2 model identified with sign-constraints:
params222s <- c(-11.964, 155.024, 11.636, 124.988, 1.314, 0.145, 0.094, 1.292,
 -0.389, -0.07, -0.109, -0.281, 1.248, 0.077, -0.04, 1.266, -0.272, -0.074,
  0.034, -0.313, 0.903, 0.718, -0.324, 2.079, 7.00, 1.44, 0.742)
W_222 <- matrix(c(1, 1, -1, 1), nrow=2, byrow=FALSE)
mod222s <- GMVAR(p=2, M=2, d=2, params=params222s, parametrization="mean",
                 structural_pars=list(W=W_222))
mod222s

# The same reduced form model, modified W and lambda:
mod222s_2 <- reorder_W_columns(mod222s, perm=2:1)
mod222s_2
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
 }
}
\seealso{
\code{\link{fitGMVAR}}, \code{\link{GMVAR}}, \code{\link{GIRF}}, \code{\link{gmvar_to_sgmvar}},
 \code{\link{swap_W_signs}}
}
