% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argumentChecks.R
\name{check_pMd}
\alias{check_pMd}
\title{Check that p, M, and d are correctly set}
\usage{
check_pMd(p, M, d, model = c("GMVAR", "StMVAR", "G-StMVAR"))
}
\arguments{
\item{p}{a positive integer specifying the autoregressive order of the model.}

\item{M}{\describe{
  \item{For \strong{GMVAR} and \strong{StMVAR} models:}{a positive integer specifying the number of mixture components.}
  \item{For \strong{G-StMVAR} models:}{a size (2x1) integer vector specifying the number of \emph{GMVAR type} components \code{M1}
   in the first element and \emph{StMVAR type} components \code{M2} in the second element. The total number of mixture components
   is \code{M=M1+M2}.}
}}

\item{d}{the number of time series in the system.}
}
\value{
Throws an error if something is wrong.
}
\description{
\code{check_pMd} checks the arguments p, M, and d.
}
\keyword{internal}
