% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROC.R
\name{ROC}
\alias{ROC}
\title{Receiver Operator Characteristics (ROC) for a \code{joint} model.}
\usage{
ROC(fit, data, Tstart, delta, control = list(), progress = TRUE, boot = FALSE)
}
\arguments{
\item{fit}{a joint model fit by the  \code{joint} function.}

\item{data}{the data to which the original \code{joint} model was fit.}

\item{Tstart}{The start of the time window of interest, \code{Tstart} denotes the time
point up to which longitudinal process(es) is used in calculation of survival probabilities.}

\item{delta}{scalar denoting the length of time interval to check for failure times.}

\item{control}{list of control arguments to be passed to \code{\link{dynPred}}, which
acts as the main workhorse function for \code{ROC}. Takes default arguments of 
\code{\link{dynPred}} if not supplied.}

\item{progress}{should a progress bar be shown, showing the current progress of the ROC
function (% showing the completed proportion of those alive at \code{Tstart}.). Defaults
to \code{progress = TRUE}.}

\item{boot}{logical. For usage via \code{\link{bootAUC}} only, do not change from 
the default \code{boot=FALSE}.}
}
\value{
A list of class \code{ROC.joint} consisting of: \describe{
  \item{\code{Tstart}}{numeric denoting the start of the time window of interest; all dynamic
  predictions generated used longitudinal information up-to time \eqn{T_{\mathrm{start}}}.}
  \item{\code{delta}}{scalar which denotes length of interval to check, such that the window
  is defined by \eqn{[T_{\mathrm{start}}, T_{\mathrm{start}}, + \delta]}.}
  \item{\code{candidate.u}}{candidate vector of failure times to calculate dynamic probability
   of surviving for each subject alive in \code{data} at time \eqn{T_{\mathrm{start}}}.}
  \item{\code{window.failures}}{numeric denoting the number of observed failures in
  \eqn{[T_{\mathrm{start}}, T_{\mathrm{start}}, + \delta]}.}
  \item{\code{Tstart.alive}}{numeric denoting the risk set at \code{Tstart}.}
  \item{\code{metrics}}{a \code{data.frame} containing probabilistic \code{thresholds} with:
  \code{TP} true positives; \code{FN} false negatives; \code{FP} false positives;
  \code{TN} true negatives; \code{TPR} true positive rate (sensitivity); \code{FPR} false
  positive rate (1-specificity); \code{Acc} accuracy; \code{PPV} positive predictive value
  (precision); \code{NPV} negative predictive value; \code{F1s} F1 score and \code{J} Youden's
  J statistic.}
  \item{AUC}{the area under the curve.}
  \item{BrierScore}{calculated Brier score (for each subject) along with attributed summary.}
  \item{MH.acceptance.bar}{mean acceptance of M-H scheme across all subjects.}
  \item{simulation.info}{list containing information about call to \code{dynPred}.}
}
}
\description{
Using longitudinal information available up to a time, establish diagnostic
capabilities (ROC, AUC and Brier score) of a fitted joint model.
}
\examples{
\donttest{
data(PBC)
PBC$serBilir <- log(PBC$serBilir)
long.formulas <- list(serBilir ~ drug * time + (1 + time|id))
surv.formula <- Surv(survtime, status) ~ drug
family <- list('gaussian')
fit <- joint(long.formulas, surv.formula, PBC, family)
(roc <- ROC(fit, PBC, Tstart = 8, delta = 2, control = list(nsim = 25)))
plot(roc)
}
}
\seealso{
\code{\link{dynPred}}, \code{\link{bootAUC}} and \code{\link{plot.ROC.joint}}.
}
\author{
James Murray (\email{j.murray7@ncl.ac.uk}).
}
