% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condb.R
\name{cond.ranefs}
\alias{cond.ranefs}
\title{Obtain conditional distribution of the random effects}
\usage{
cond.ranefs(fit, burnin = 500L, N = 3500L, tune = 2)
}
\arguments{
\item{fit}{a joint model fit by the \code{joint} function.}

\item{burnin}{Number of burn-in iterations to discard, defaults to 500.}

\item{N}{Number of MC iterations to carry out \emph{post} burn-in, defaults to 3500.}

\item{tune}{Tuning parameter, problem-specific, defaults to 2.}
}
\value{
A list of class \code{cond.b.joint} containing: \describe{
 \item{walks}{A list of length \code{n} containing the history of \eqn{b_i} post burn-in.}
 \item{acceptance}{A numeric vector containing the acceptance rate for each sampled subject.}
 \item{M}{The ModelInfo list from \code{joint}. Used by S3 methods for class 
          \code{cond.b.joint}.}
 \item{bhats}{Posterior estimates at MLEs for the random effects. Same as \code{ranef(joint)}.}
 \item{Sigmahats}{The covariances of \code{bhats}.}
 \item{D}{The MLE estimate for the variance-covariance matrix of random effects from 
 \code{fit}.}
 \item{q}{Dimension of random effects.}
 \item{K}{Number of responses.} 
 \item{qnames}{The names of the random effects as determined by call to \code{joint}.}
 \item{burnin}{The amount of burn-in used.}
 \item{N}{Number of MC iterations.}
 \item{tune}{tuning parameter used}
 \item{nobs}{The number of observations for each subject for each response.}
 \item{elapsed.time}{Time taken for \code{cond.ranefs} to complete.}
}
}
\description{
Obtain the conditional distribution of the random effects of a \code{joint} model
fit. This is achieved by a Metropolis scheme. Approximate normality across random effects is
expected, and could be useful in diagnosing potential issues surrounding model fits.
}
\examples{
\donttest{
dat <- simData()$data
long.formulas <- list(Y.1 ~ time + cont + bin + (1 + time|id), 
                      Y.2 ~ time + cont + bin + (1 + time|id))
surv.formula <- Surv(survtime, status) ~ bin
fit <- joint(long.formulas, surv.formula, dat, list("gaussian","gaussian"))
cond.b <- cond.ranefs(fit, burnin = 50L, N = 1000, tune = 2)
cond.b
plot(cond.b) # Overall 
plot(cond.b, id = 1) # Plot the first subject (see plot.cond.b.joint).
}
}
\seealso{
\code{\link{ranef.joint}} \code{\link{plot.cond.b.joint}}
}
