% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrt.R
\name{LR.test}
\alias{LR.test}
\title{Likelihood Ratio Test of the Proportional Odds Assumption}
\usage{
LR.test(model, call=FALSE)
}
\arguments{
\item{model}{a single model object to be tested.}

\item{call}{a logical vector to indicate if the model call should be printed.}
}
\value{
\item{model}{the call of the model tested}

\item{df}{the degrees of freedom}

\item{rdf}{residual degrees of freedom}

\item{rdev}{residual deviance}

\item{LRT}{likelihood ratio test statistic}

\item{prob}{the p-values of test}

\item{call}{a logical vector}
}
\description{
Provides the means of testing the parallel regression assumption
in the ordinal regression  models. Also available is the brant.test().
}
\details{
The parallel regression assumption for the ordinal regression  model
can be tested With this function. It currently supports objects of class
serp() and vglm().
}
\examples{

require(serp)

sp <- serp(ordered(RET) ~ DIAB + GH + BP, link="logit",
           slope="parallel", reverse=TRUE, data = retinopathy)
LR.test(sp, call = TRUE)

}
\seealso{
\code{\link{brant.test}}, \code{\link{hosmerlem}}, \code{\link{lipsitz}},
 \code{\link{pulkroben}}
}
