% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenarios-fr.R
\name{r_ou}
\alias{r_ou}
\title{Simulation of an Ornstein--Uhlenbeck process}
\usage{
r_ou(n, t = seq(0, 1, len = 201), mu = 0, alpha = 1, sigma = 1,
  x0 = rnorm(n, mean = mu, sd = sigma/sqrt(2 * alpha)))
}
\arguments{
\item{n}{number of trajectories to sample.}

\item{t}{evaluation times for the trajectories, a vector.}

\item{mu}{mean of the process, a scalar.}

\item{alpha}{strength of the drift, a positive scalar.}

\item{sigma}{diffusion coefficient, a positive scalar.}

\item{x0}{a vector of length \code{n} giving the initial
values of the Ornstein--Uhlenbeck trajectories. By default, \code{n}
points are sampled from the stationary distribution. If a single scalar
is passed, then the same \code{x0} is employed for all the trajectories.}
}
\value{
Random trajectories, an \code{\link[fda.usc]{fdata}} object of
length \code{n} and \code{t} as \code{argvals}.
}
\description{
Simulation of trajectories of the Ornstein--Uhlenbeck process
\eqn{\{X_t\}}{{X_t}}. The process is the solution to the stochastic
differential equation
\deqn{\mathrm{d}X_t = \alpha (X_t - \mu)\mathrm{d}t + \sigma \mathrm{d}W_t,
}{dX_t = \alpha (X_t - \mu) dt + \sigma dW_t,}
whose stationary distribution is \eqn{N(\mu, \sigma^2 / (2 \alpha))}, for
\eqn{\alpha, \sigma > 0} and \eqn{\mu \in R}.

Given an initial point \eqn{x_0} and the evaluation times
\eqn{t_1, \ldots, t_m}, a sample trajectory \eqn{X_{t_1}, \ldots, X_{t_m}}
can be obtained by sampling the joint Gaussian distribution of
\eqn{(X_{t_1}, \ldots, X_{t_m})}.
}
\examples{
# Same initial point
plot(r_ou(n = 20, x0 = 5), col = viridisLite::viridis(20))

# Different initial points
plot(r_ou(n = 100, alpha = 2, sigma = 4, x0 = 1:100),
     col = viridisLite::viridis(100))
}
\author{
Eduardo García-Portugués.
}
