#' Welcome Page
#'
#' @importFrom shiny tagList tags
#'
#' @export
#'
#' @return A welcome page for your `{golem}` app
golem_welcome_page <- function() {
  tagList(
    tags$head(
      tags$style("
        body {
          background-color: #7176b8;
        }

          h1 {
            font-family: 'Rubik', sans-serif;
            font-weight: 700;
            font-size: 3rem;
            color: #ffffff;
          }

          .main {
            display: flex;
            flex-direction: column;
            align-items: center;
            height: 100vh;
            gap: 2rem;
            padding-top: 2rem;
          }

          .title {
            display: flex;
            justify-content: center;
            align-items: center;
          }

          .golem_section {
            display: flex;
            flex-direction: column;
            align-items: center;
            border: 2.5px solid #4b5178;
            border-radius: 15px;
            padding: 1.4rem 7rem;
            width: 50%;
            margin-top: 40px;
          }

          .golem_section:hover, .doc_content:hover {
            box-shadow: 0px 0px 18px -6px #38424f;
          }

          .golem_content {
            display: grid;
            grid-template-rows: 40px auto;
            grid-row-gap:4rem;
            row-gap: 1rem;
          }

          .golem_logo {
            top: -54px;
            position: relative;
            display: flex;
            justify-content: center;
          }

          .description {
            font-family: 'Rubik', sans-serif;
            font-size: 1.5rem;
            color: #ffffff;
            line-height: 1.8;
          }

          .description a, .description span {
            color: #ffffff;
            text-decoration: none;
            background-color: #38424f61;
            padding: .35rem .60rem;
            border-radius: 5px;
            line-height: 2;
          }

          .description a {
            cursor: pointer;
          }

          .center-text {
            text-align: center;
          }

          .doc_section {
            display: grid;
            grid-template-columns: 1.5fr 1fr;
            gap: 2rem;
            width: 50%;
          }

          @media ( max-width: 850px ) {
            .doc_section {
              grid-template-columns: 1fr;
            }
          }

          .doc_content {
            padding: 1rem 2rem;
            border-radius: 10px;
            background-color: #38424f61;
            gap: 1rem;
            border: 2.5px solid #4b5178
          }

          .doc_content:hover {
            text-decoration: none;
          }

          .doc_modules {
            display: grid;
            gap: 2rem;
          }
        ")
    ),
    tags$div(
      class = "main",
      tags$div(
        class = "title",
        style = "",
        tags$h1("Welcome to your {golem} app!")
      ),
      tags$div(
        class = "golem_section",
        tags$div(
          class = "golem_content",
          tags$div(
            class = "golem_logo",
            tags$img(
              style = "height:80px;",
              src = "https://raw.githubusercontent.com/ThinkR-open/golem/master/inst/rstudio/templates/project/golem.png",
            )
          ),
          tags$div(
            tags$p(
              class = "description center-text",
              "This page is generated by the ",
              tags$span(
                class = "code",
                "golem_welcome_page()"
              ),
              "function in",
              tags$span(
                class = "code",
                "R/app_ui.R"
              ),
              ". Go ahead and replace it with your own code!"
            )
          )
        )
      ),
      tags$div(
        class = "doc_section",
        tags$div(
          class = "doc_modules",
          tags$a(
            class = "doc_content",
            href = "https://golemverse.org/",
            target = "_blank",
            tags$h4(
              class = "description",
              "Golemverse"
            ),
            tags$p(
              class = "description",
              "The golemverse is a collection of R packages for building {shiny} apps that need to be safely shipped to production.",
              tags$br(),
              tags$span(class = "code", "{brochure}"),
              tags$span(class = "code", "{shinipsum}"),
              tags$span(class = "code", "{shinidraw}"),
              tags$span(class = "code", "{dockerfiler}"),
              " and more!",
              tags$br(),
              "Explore the Golemverse at https://golemverse.org/ and discover more packages!"
            )
          ),
          tags$a(
            class = "doc_content",
            href = "https://github.com/ThinkR-open/golem",
            target = "_blank",
            tags$h4(
              class = "description",
              "Feedbacks welcome"
            ),
            tags$p(
              class = "description",
              "If you have any idea or suggestion, feel free to open an issue.",
            )
          )
        ),
        tags$a(
          class = "doc_content",
          href = "https://engineering-shiny.org/",
          target = "_blank",
          tags$h4(
            class = "description",
            "Read our Book"
          ),
          tags$p(
            class = "description",
            "Learn more about building {shiny} apps for production with the 'Engineering Production-Grade Shiny' Apps book.",
            tags$br(),
            tags$br(),
            "The online version of the book is free to read at https://engineering-shiny.org/."
          )
        )
      )
    )
  )
}
