% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildsteps_templates.R
\name{cr_buildstep_gcloud}
\alias{cr_buildstep_gcloud}
\title{A buildstep template for gcloud}
\usage{
cr_buildstep_gcloud(component = c("gcloud", "bq", "gsutil", "kubectl"), ...)
}
\arguments{
\item{component}{What gcloud service you need, such as "gcloud", "bq" or "gsutil"}

\item{...}{
  Arguments passed on to \code{\link[=cr_buildstep]{cr_buildstep}}
  \describe{
    \item{\code{name}}{name of docker image to call appended to \code{prefix}}
    \item{\code{args}}{character vector of arguments}
    \item{\code{prefix}}{prefixed to name - set to "" to suppress.  Will be suppressed if \code{name} starts with gcr.io}
    \item{\code{entrypoint}}{change the entrypoint for the docker container}
    \item{\code{dir}}{The directory to use, relative to /workspace e.g. /workspace/deploy/}
    \item{\code{id}}{Optional id for the step}
    \item{\code{env}}{Environment variables for this step.  A character vector for each assignment}
    \item{\code{volumes}}{volumes to connect and write to}
    \item{\code{waitFor}}{Whether to wait for previous buildsteps to complete before running.  Default it will wait for previous step.}
  }}
}
\description{
This enables an optimised version of gcloud docker for your buildstep such as \code{gcr.io/google.com/cloudsdktool/cloud-sdk:alpine}
}
\seealso{
\url{https://github.com/GoogleCloudPlatform/cloud-builders/tree/master/gcloud}

Other Cloud Buildsteps: 
\code{\link{cr_buildstep_bash}()},
\code{\link{cr_buildstep_decrypt}()},
\code{\link{cr_buildstep_df}()},
\code{\link{cr_buildstep_docker}()},
\code{\link{cr_buildstep_edit}()},
\code{\link{cr_buildstep_extract}()},
\code{\link{cr_buildstep_gitsetup}()},
\code{\link{cr_buildstep_mailgun}()},
\code{\link{cr_buildstep_nginx_setup}()},
\code{\link{cr_buildstep_pkgdown}()},
\code{\link{cr_buildstep_run}()},
\code{\link{cr_buildstep_r}()},
\code{\link{cr_buildstep_secret}()},
\code{\link{cr_buildstep_slack}()},
\code{\link{cr_buildstep}()}
}
\concept{Cloud Buildsteps}
