% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildsteps.R
\name{cr_buildstep_df}
\alias{cr_buildstep_df}
\title{Convert a data.frame into cr_buildstep}
\usage{
cr_buildstep_df(x)
}
\arguments{
\item{x}{A data.frame of steps to turn into buildsteps, with at least name and args columns}
}
\description{
Helper to turn a data.frame of buildsteps info into format accepted by \link{cr_build}
}
\details{
This helps convert the output of \link{cr_build} into valid \link{cr_buildstep} so it can be sent back into the API

If constructing arg list columns then \link{I} suppresses conversion of the list to columns that would otherwise break the yaml format
}
\examples{
y <- data.frame(name = c("docker", "alpine"),
                args = I(list(c("version"), c("echo", "Hello Cloud Build"))),
                id = c("Docker Version", "Hello Cloud Build"),
                prefix = c(NA, ""),
                stringsAsFactors = FALSE)
cr_buildstep_df(y)
}
\seealso{
Other Cloud Buildsteps: 
\code{\link{cr_buildstep_bash}()},
\code{\link{cr_buildstep_decrypt}()},
\code{\link{cr_buildstep_docker}()},
\code{\link{cr_buildstep_edit}()},
\code{\link{cr_buildstep_extract}()},
\code{\link{cr_buildstep_gcloud}()},
\code{\link{cr_buildstep_gitsetup}()},
\code{\link{cr_buildstep_mailgun}()},
\code{\link{cr_buildstep_nginx_setup}()},
\code{\link{cr_buildstep_pkgdown}()},
\code{\link{cr_buildstep_run}()},
\code{\link{cr_buildstep_r}()},
\code{\link{cr_buildstep_secret}()},
\code{\link{cr_buildstep_slack}()},
\code{\link{cr_buildstep}()}
}
\concept{Cloud Buildsteps}
