% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upload.R
\name{gcs_upload}
\alias{gcs_upload}
\title{Upload a file of arbitary type}
\usage{
gcs_upload(file, bucket = gcs_get_global_bucket(), type = NULL,
  name = deparse(substitute(file)), object_function = NULL,
  object_metadata = NULL, predefinedAcl = c("private", "authenticatedRead",
  "bucketOwnerFullControl", "buckerOwnerRead", "projectPrivate", "publicRead"),
  upload_type = c("simple", "resumable"))
}
\arguments{
\item{file}{data.frame, list, R object or filepath (character) to upload file}

\item{bucket}{bucketname you are uploading to}

\item{type}{MIME type, guessed from file extension if NULL}

\item{name}{What to call the file once uploaded. Default is the filepath}

\item{object_function}{If not NULL, a \code{function(input, output)}}

\item{object_metadata}{Optional metadata for object created via \link{gcs_metadata_object}}

\item{predefinedAcl}{Specify user access to object. Default is 'private'}

\item{upload_type}{Override automatic decision on upload type}
}
\value{
If successful, a metadata object
}
\description{
Upload up to 5TB
}
\details{
When using \code{object_function} it expects a function with two arguments:
\itemize{
  \item \code{input} The object you supply in file to write from
  \item \code{output} The filename you write to
 }


By default the \code{upload_type} will be 'simple' if under 5MB, 'resumable' if over 5MB.
  'Multipart' upload is used if you provide a \code{object_metadata}.

If \code{object_function} is NULL and \code{file} is not a character filepath,
  the defaults are:

\itemize{
  \item file's class is \code{data.frame} - \link[utils]{write.csv}
  \item file's class is \code{list} - \link[jsonlite]{toJSON}
 }

If \code{object_function} is not NULL and \code{file} is not a character filepath,
  then \code{object_function} will be applied to the R object specified
  in \code{file} before upload. You may want to also use \code{name} to ensure the correct
  file extension is used e.g. \code{name = 'myobject.feather'}

If \code{file} or \code{name} argument contains folders e.g. \code{/data/file.csv} then
  the file will be uploaded with the same folder structure e.g. in a \code{/data/} folder.
Use \code{name} to override this.
}
\section{scopes}{


Requires scopes \code{https://www.googleapis.com/auth/devstorage.read_write}
  or \code{https://www.googleapis.com/auth/devstorage.full_control}
}

