% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate.R
\name{gl_translate_languages}
\alias{gl_translate_languages}
\title{Lists languages from Google Translate API}
\usage{
gl_translate_languages(target = "en")
}
\arguments{
\item{target}{If specified, language names are localized in target language}
}
\value{
A tibble of supported languages
}
\description{
Returns a list of supported languages for translation.
}
\details{
Supported language codes, generally consisting of its ISO 639-1 identifier. (E.g. \code{'en', 'ja'}).
In certain cases, BCP-47 codes including language + region identifiers are returned (e.g. \code{'zh-TW', 'zh-CH'})
}
\examples{

\dontrun{

# default english names of languages supported
gl_translate_languages()

# specify a language code to get other names, such as Danish
gl_translate_languages("da")

}
}
\seealso{
\url{https://cloud.google.com/translate/docs/reference/languages}

Other translations: 
\code{\link{gl_translate}()},
\code{\link{gl_translate_detect}()}
}
\concept{translations}
