% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_mosaic.R
\name{gt_mosaic}
\alias{gt_mosaic}
\title{Mosaic rasters with different origins and resolutions}
\usage{
gt_mosaic(r_list)
}
\arguments{
\item{r_list}{List of rasters}
}
\value{
Returns a raster.
}
\description{
The \code{\link[raster:mosaic]{raster::mosaic()}} function requires rasters to have the same origin and resolution.
However, when producing multiple rasters to query traffic data across a large study area, the
rasters will not have the same origins and may not have the same resolutions (in cases where rasters
at different latitudes are queried). \code{gt_mosaic()} allows for mosaicing rasters with different
origins and resolutions.
}
\examples{
r1 <- raster::raster(ncol=10, nrow=10, xmn = -10, xmx = 1,  ymn = -10, ymx = 1)
r2 <- raster::raster(ncol=10, nrow=10, xmn = 0,   xmx = 10, ymn = 0,   ymx = 10)
r3 <- raster::raster(ncol=10, nrow=10, xmn = 9,   xmx = 20, ymn = 9,   ymx = 20)

r123 <- list(r1, r2, r3)

r <- gt_mosaic(r123)

}
