% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_tricot.R
\name{rank_tricot}
\alias{rank_tricot}
\title{Build Plackett-Luce rankings from tricot dataset}
\usage{
rank_tricot(
  data,
  items,
  input,
  group = FALSE,
  validate.rankings = FALSE,
  additional.rank = NULL,
  ...
)
}
\arguments{
\item{data}{a data.frame with columns specified by items and input values}

\item{items}{a character or numerical vector for indexing the column(s) 
containing the item names in \code{data}}

\item{input}{a character or numerical vector for indexing the column(s) 
containing the values in \code{data} to be ranked}

\item{group}{logical, if \code{TRUE} return an object of class "grouped_rankings"}

\item{validate.rankings}{logical, if \code{TRUE} implements a check on ranking consistency 
looking for possible ties, NA or letters other than A, B, C. These entries are set to 0}

\item{additional.rank}{optional, a data frame for the comparisons between 
tricot items and the local item}

\item{...}{additional arguments passed to methods. See details}
}
\value{
a PlackettLuce "rankings" object, which is a matrix of dense rankings
}
\description{
Create an object of class "rankings" from tricot data. Tricot stands 
for "triadic comparison of technology options". Is an approach to carry out 
large decentralized agronomic field experiments as incomplete blocks. 
Each incomplete block contains a set of three randomised technologies 
out of a larger set.
}
\details{
full.output: logical, to return a list with a "rankings", 
a "grouped_rankings" and the ordered items
}
\examples{

library("PlackettLuce")
data("beans", package = "PlackettLuce")

# Using a subset of the bean data
beans = beans[1:5, 1:5]
beans[1, 1] = NA
beans[3, 4:5] = NA
beans[5, 5] = "Tie"

# The default approach do not validate rankings
# accepting any entry used in the argument input
R1 = rank_tricot(beans,
                 items = c(1:3),
                 input = c(4:5), 
                 group = FALSE)

# Using validate.rankings = TRUE, the rankings
# are only considered for those entries without 
# NAs, Ties and with any of the letters A, B, C
# this do not affect the lenght of the final ranking 
R2 = rank_tricot(beans,
                 items = c(1:3),
                 input = c(4:5),
                 validate.rankings = TRUE,
                 group = FALSE)

coef(PlackettLuce(R1))

coef(PlackettLuce(R2))

############################################################

# pass the comparison with local item as an additional rankings, then
# each of the 3 varieties are compared separately with the local item
# and return an object of class grouped_rankings

data("beans", package = "PlackettLuce")

G = rank_tricot(data = beans,
                 items = c(1:3),
                 input = c(4:5),
                 group = TRUE,
                 additional.rank = beans[c(6:8)])

head(G)

}
\references{
van Etten J., et al. (2016). Experimental Agriculture, 55(S1), 275–296.
\doi{https://doi.org/10.1017/S0014479716000739}
}
\seealso{
\code{\link[PlackettLuce]{rankings}}, \code{\link{breadwheat}}

Other rank functions: 
\code{\link{rank_binomial}()},
\code{\link{rank_numeric}()},
\code{\link{rank_paircomp}()}
}
\author{
Kauê de Sousa and Jacob van Etten, with ideas from Heather Turner
}
\concept{rank functions}
