% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unstrap.R
\name{unstrap}
\alias{unstrap}
\title{Remove bootstrap css from crosstalk components}
\usage{
unstrap(x)
}
\arguments{
\item{x}{a crosstalk component, such as \code{\link[crosstalk:filter_select]{crosstalk::filter_select()}}}
}
\value{
The component \code{x} but with any \code{"boostrap"} dependency removed from its
\code{html_dependencies} attribute.
}
\description{
If your page renders weirdly, it might be because a crosstalk component like
\code{\link[crosstalk:filter_select]{crosstalk::filter_select()}} is injecting unexpected css into
your page, which happens because they try to use the Bootstrap css library by
default.  The \code{unstrap()} function prevents that from happening.
}
\examples{
# The fs object will inject css into your page.
if (requireNamespace("crosstalk", quietly = TRUE)) {
  df <- crosstalk::SharedData$new(mtcars)

  fs <- crosstalk::filter_select(
      id = "myselector",
      label = "select something",
      sharedData = df,
      group = ~cyl
    )

  # The fs_nobootstrap object won't inject css into your page.
  fs_nobootstrap <- unstrap(fs)
}
}
