% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/forecast.DDE.R
\name{forecast.DDE}
\alias{forecast.DDE}
\title{Compute and Plot the Forecasts Based on a Fitted DDE Model}
\usage{
forecast.DDE(y, times, h, pars, beta, proc, more, tau, ndelay, fdobj0, fdobj.d,
  ask = FALSE, xlab = NULL, ylab = NULL, xlim = NULL, ylim = NULL,
  axes = NULL, ...)
}
\arguments{
\item{y}{The observed data matrix}

\item{times}{A sequence of time points at which data are observed. must be evenly spaced to be able to fit arima model to the residual.}

\item{h}{How many lags to predict forward.}

\item{pars}{The fitted parameters for the DDE.}

\item{beta}{The fitted parameters for the contribution of lags of delays.}

\item{proc}{The \code{proc} object returned from estimation functions.}

\item{more}{An object specifying additional arguments to fn.}

\item{tau}{A list of delay lags.}

\item{ndelay}{A vector inidicating which state process has a delay term.}

\item{fdobj0}{A functional data object fitted with the initial history part of the data.}

\item{fdobj.d}{A functional data object fitted by generalized profiling.}

\item{ask}{a logical value: If TRUE, each curve is shown separately, and the plot advances with a mouse click.}

\item{xlab}{a label for the horizontal axis.}

\item{ylab}{a label for the vertical axis.}

\item{xlim}{a vector of length 2 containing axis limits for the horizontal axis.}

\item{ylim}{a vector of length 2 containing axis limits for the vertical axis.}

\item{axes}{Either a logical or a list or \code{NULL}.
##' \describe{
\item{logical}{whether axes should be drawn on the plot}
\item{list}{a list used to create custom axes used to create axes via     \code{do.call(x$axes[[1]], x$axes[-1])}.}
}}

\item{...}{additional plotting arguments that can be used with function \code{plot}.}
}
\value{
'done'
}
\description{
The fitted process and forecasts are plotted.
These may be either plotted simultaneously, as \code{matplot} does for
multivariate data, or one by one with a mouse click to move from one
plot to another. The function also accepts the other \code{plot}
specification arguments that the regular plot does. The forecast
is done by integreting the process forward and forecast confidence
is based on an arima model fitted to the residual using
\code{auto.arima} function from \code{forecast} package.
}
\seealso{
\code{\link{IntegrateForward.DDE}}
}

