% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpb.importance.R
\name{gpb.importance}
\alias{gpb.importance}
\title{Compute feature importance in a model}
\usage{
gpb.importance(model, percentage = TRUE)
}
\arguments{
\item{model}{object of class \code{gpb.Booster}.}

\item{percentage}{whether to show importance in relative percentage.}
}
\value{
For a tree model, a \code{data.table} with the following columns:
\itemize{
  \item{\code{Feature}: Feature names in the model.}
  \item{\code{Gain}: The total gain of this feature's splits.}
  \item{\code{Cover}: The number of observation related to this feature.}
  \item{\code{Frequency}: The number of times a feature splited in trees.}
}
}
\description{
Creates a \code{data.table} of feature importances in a model.
}
\examples{
\donttest{
data(agaricus.train, package = "gpboost")
train <- agaricus.train
dtrain <- gpb.Dataset(train$data, label = train$label)

params <- list(
  objective = "binary"
  , learning_rate = 0.1
  , max_depth = -1L
  , min_data_in_leaf = 1L
  , min_sum_hessian_in_leaf = 1.0
)
model <- gpb.train(
    params = params
    , data = dtrain
    , nrounds = 5L
)

tree_imp1 <- gpb.importance(model, percentage = TRUE)
tree_imp2 <- gpb.importance(model, percentage = FALSE)
}
}
