% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{confint.GPPM}
\alias{confint.GPPM}
\title{Confidence Intervals}
\usage{
\method{confint}{GPPM}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{object of class GPPM. Must be fitted, that is, a result from \code{\link{fit.GPPM}}.}

\item{parm}{vector of strings. The parameters for which confidence intervals are desired. If missing, confidence intervals for all parameters are returned.}

\item{level}{scalar from 0 to 1. The confidence level required.}

\item{...}{additional arguments (currently not used).}
}
\value{
A matrix (or vector) with columns giving lower and upper confidence limits for each parameter. These will be labeled as (1-level)/2 and 1 - (1-level)/2 in \\% (by default 2.5\\% and 97.5\\%).
}
\description{
Computes confidence intervals for one or more parameters in a fitted GPPM.
}
\examples{
\donttest{
data("demoLGCM")
lgcm <- gppm(
  "muI+muS*t", "varI+covIS*(t+t#)+varS*t*t#+(t==t#)*sigma",
  demoLGCM, "ID", "y"
)
lgcmFit <- fit(lgcm)
confInts <- confint(lgcmFit)
}
}
\seealso{
Other functions to extract from a GPPM: 
\code{\link{SE}()},
\code{\link{coef.GPPM}()},
\code{\link{covFun}()},
\code{\link{fitted.GPPM}()},
\code{\link{getData}()},
\code{\link{getIntern}()},
\code{\link{logLik.GPPM}()},
\code{\link{maxNObs}()},
\code{\link{meanFun}()},
\code{\link{nObs}()},
\code{\link{nPars}()},
\code{\link{nPers}()},
\code{\link{nPreds}()},
\code{\link{parEsts}()},
\code{\link{pars}()},
\code{\link{preds}()},
\code{\link{vcov.GPPM}()}
}
\concept{functions to extract from a GPPM}
