% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradDescent.Methods.R
\name{adadelta}
\alias{adadelta}
\title{Adadelta learn}
\usage{
adadelta(inputData, outputData, list)
}
\arguments{
\item{inputData}{a matrix of input data that created inside gradDescent.learn
function.}

\item{outputData}{a matrix of output data that created inside gradDescent.learn
function.}

\item{list}{a list of parameter that customize the learn.
       
\itemize{
\item \code{rowLength}: a integer of data length (row).
\item \code{theta}: a matrix of float number of current model value.
\item \code{alpha} : a float value for learning rate.
\item \code{momentum} : a float value to give a constant speed to learning process..
\item \code{smooth} : a float value to handle zero division issue in certain learning method.
\item \code{stochastic} : a boolean value to enable stochastic, which mean to select one random
                   value in data train, instead process all data train. 
\item \code{accelerate} : a boolean value to enable accelerate in the learning with momentum.
\item \code{maxIter} : Adaptive Moment Estimation method to calculate gradient.
}}
}
\value{
a matrix of theta
}
\description{
This is internal function of learning stage that implement Adadelta 
method to create model.
}
\references{
M. Zeiler. (2012). Adadelta: An Adaptive Learning Rate Method
arXiv: 1212.5701v1, 1-6.
}

