% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grand.text.R
\name{grand.text}
\alias{grand.text}
\title{Generate a Guidelines for Reporting About Network Data (GRAND) narrative summary}
\usage{
grand.text(G, digits = 3)
}
\arguments{
\item{G}{An \code{\link{igraph}} object with GRAND attributed}

\item{digits}{numeric: number of decimal places to report}
}
\value{
string: Narrative summary of G
}
\description{
The \code{grand.text} function writes a narrative summary of GRAND attributes that were
added to an \code{igraph} object using \code{\link[=grand]{grand()}}.
}
\examples{
#A weighted, directed network
data(airport)  #Load example data
narrative <- grand.text(airport)  #Generate narrative

#A bipartite network
data(cosponsor)  #Load example data
narrative <- grand.text(cosponsor)  #Generate narrative

#A signed network
data(senate)  #Load example data
narrative <- grand.text(senate)  #Generate narrative
}
