% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_transformations.R
\name{Gamma2Sigma}
\alias{Gamma2Sigma}
\alias{Gamma2Theta}
\alias{Sigma2Gamma}
\alias{Theta2Gamma}
\alias{Sigma2Theta}
\alias{Theta2Sigma}
\alias{Theta2Theta}
\alias{Sigma2Sigma}
\alias{Gamma2Gamma}
\alias{matrix2matrix}
\title{Conversion between Huesler-Reiss parameter matrices}
\usage{
Gamma2Sigma(Gamma, k = NULL, full = FALSE, check = TRUE)

Gamma2Theta(Gamma, k = NULL, full = FALSE, check = TRUE)

Sigma2Gamma(Sigma, k = NULL, full = FALSE, check = TRUE)

Theta2Gamma(Theta, k = NULL, full = FALSE, check = TRUE)

Sigma2Theta(
  Sigma,
  k1 = NULL,
  k2 = NULL,
  full1 = FALSE,
  full2 = FALSE,
  check = TRUE
)

Theta2Sigma(
  Theta,
  k1 = NULL,
  k2 = NULL,
  full1 = FALSE,
  full2 = FALSE,
  check = TRUE
)

Theta2Theta(
  Theta,
  k1 = NULL,
  k2 = NULL,
  full1 = FALSE,
  full2 = FALSE,
  check = TRUE
)

Sigma2Sigma(
  Sigma,
  k1 = NULL,
  k2 = NULL,
  full1 = FALSE,
  full2 = FALSE,
  check = TRUE
)

Gamma2Gamma(Gamma, check = TRUE)

matrix2matrix(
  M,
  name1 = c("Gamma", "Sigma", "Theta")[1],
  name2 = c("Gamma", "Sigma", "Theta")[1],
  k1 = NULL,
  k2 = NULL,
  full1 = FALSE,
  full2 = FALSE,
  check = TRUE
)
}
\arguments{
\item{Gamma}{Numeric \dxd variogram matrix.}

\item{k}{\code{NULL} if the input/output matrix is \eSigma/\eTheta.
Else, an integer between 1 and d indicating the value of k in \eSigmaK, \eThetaK.}

\item{full}{Logical. If \code{TRUE} and \code{!is.null(k)},
the input/output matrix is a \dxd matrix with the kth row filled with zeros.}

\item{check}{Whether to check the inputs and call \code{ensure_matrix_symmetry_and_truncate_zeros}
on the outputs.}

\item{Sigma}{Numeric \dxd or \d1xd1 covariance matrix.}

\item{Theta}{Numeric \dxd or \d1xd1 precision matrix.}

\item{k1}{\code{NULL} if the input matrix is \eSigma/\eTheta.
Else, an integer between 1 and d indicating the value of k in \eSigmaK, \eThetaK.}

\item{k2}{\code{NULL} if the output matrix is \eSigma/\eTheta.
Else, an integer between 1 and d indicating the value of k in \eSigmaK, \eThetaK.}

\item{full1}{Logical. If \code{TRUE} and \code{!is.null(k1)},
the input is a \dxd matrix with the kth row filled with zeros.}

\item{full2}{Logical. If \code{TRUE} and \code{!is.null(k2)},
the output is a \dxd matrix with the kth row filled with zeros.}

\item{M}{Numeric matrix, \eGamma, \eSigma, or \eTheta.}

\item{name1}{Name of the input representation.}

\item{name2}{Name of the output representation.}
}
\value{
The desired parameter matrix corresponding to the specified inputs.
}
\description{
Converts between different matrices that parametrize the same
Huesler-Reiss distribution:
\eGamma, \eSigma, \eTheta, \eSigmaK, \eThetaK.
The \d1xd1 matrices \eSigmaK and \eThetaK can also be given/returned
as \dxd matrices with the kth row and column filled with zeros.
}
\details{
If \code{k}, \code{k1}, or \code{k2} is \code{NULL}, the corresponding \verb{full*} argument is ignored.

\code{Gamma2Gamma} only checks and returns the input.

\code{matrix2matrix} is a wrapper function that calls the corresponding
conversion function implied by \code{name1}, \code{name2}.
}
\seealso{
Other parameter matrix transformations:
\code{\link{Gamma2graph}()},
\code{\link{chi2Gamma}()},
\code{\link{par2Matrix}()}
}
\concept{matrixTransformations}
