% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmodel.block.R
\name{gmodel.block}
\alias{gmodel.block}
\title{Generate binary random graphs based on stochastic blockmodel}
\usage{
gmodel.block(W, n, rep = 1, noloop = TRUE)
}
\arguments{
\item{W}{a \eqn{(K\times K)} blockmodel matrix.}

\item{n}{the number of nodes for each observation.}

\item{rep}{the number of observations to be generated.}

\item{noloop}{a logical value; TRUE for graphs without self-loops, FALSE otherwise.}
}
\value{
a named list containing
\describe{
\item{G}{depending on \code{rep} value, \describe{
\item{(rep=1)}{an \eqn{(n\times n)} observation, or}
\item{(rep>1)}{a length-\code{rep} list where each element
is an observation is an \eqn{(n\times n)} realization from the model.}
}
}
\item{P}{an \eqn{(n\times n)} probability matrix of generating each edge.}
}
}
\description{
Given a \eqn{(K\times K)} stochastic blockmodel W, \code{gmodel.block}
generates an (n-by-n) binary random graphs. All K blocks have
same number of nodes, or almost identical if n is not a multiple
of K. Parameter \code{noloop} controls whether generated observations
have an edge from a node to itself, called a loop.
}
\examples{
## set inputs
W = matrix(c(0.9,0.2,0.2,0.7),nr=2)
n = 200

## generate 2 observations without self-loops.
out <- gmodel.block(W,n,rep=2,noloop=TRUE)

\donttest{
## Visualize generated graphs
par(mfrow=c(1,2), pty="s")
image(out$G[[1]]); title("Observation 1")
image(out$G[[2]]); title("Observation 2")
}

}
\seealso{
\code{\link{gmodel.P}}
}
