% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmodel.ER.R
\name{gmodel.ER}
\alias{gmodel.ER}
\title{Observations from Erdos-Renyi random graph model}
\usage{
gmodel.ER(n, mode = "prob", par = 0.5, rep = 1)
}
\arguments{
\item{n}{the number of nodes to be generated}

\item{mode}{'prob' (default) for edges to be drawn from Bernoulli
distribution independently, or 'num' for a graph to have a fixed
number of edges placed randomly}

\item{par}{a real number \eqn{\in [0,1]} for \code{mode='prob'}, or a
positive integer \eqn{\in [1, n*(n-1)/2]} for \code{mode='num'}}

\item{rep}{the number of observations to be generated.}
}
\value{
depending on \code{rep} value, either
\describe{
\item{(rep=1)}{an \eqn{(n\times n)} observation matrix, or}
\item{(rep>1)}{a length-\code{rep} list where each element
is an observation is an \eqn{(n\times n)} realization from the model.}
}
}
\description{
Erdos-Renyi random graph model is one of the most popular and
fundamental examples in modeling networks. Given n nodes,
\code{gmodel.ER} generates edges randomly from Bernoulli distribution
with a globally specified probability.
}
\details{
In network science, 'ER' model is often interchangeably used in where
we have fixed number of edges to be placed at random. The original
use of edge-generating probability is from Gilbert (1959). Therefore,
we set this algorithm to be flexible in that user can create either a
fixed number of edges placed at random or set global edge-generating probability
and draw independent observations following Bernoulli distribution.
}
\examples{
## generate 3 graphs with a global with probability 0.5
graph3 = gmodel.ER(100,par=0.5,rep=3)

## visualize
opar = par(no.readonly=TRUE)
par(mfrow=c(1,3), pty="s")
image(graph3[[1]], main="1st sample")
image(graph3[[2]], main="2nd sample")
image(graph3[[3]], main="3rd sample")
par(opar)

}
\references{
\insertRef{Erdos1959}{graphon}

\insertRef{Gilbert1959}{graphon}
}
