% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nocite_references.R
\name{nocite_references}
\alias{nocite_references}
\title{Generate Nocite Block}
\usage{
nocite_references(citekeys, citation_processor = c("pandoc", "latex"))
}
\arguments{
\item{citekeys}{Vector of citation keys in reference to a relevant BibTeX
file.}

\item{citation_processor}{Mechanism for citation processing when knitting to
PDF or otherwise using LaTeX. Selects the appropriate formatting of the
nocite command. Either "pandoc" or "latex". If processing with
pandoc-citeproc, use the nocite metadata block. If processing via a LaTeX
processor such as natbib or biblatex, put in the LaTeX \code{\\nocite\{\}}
command directly. If knitting to any non-LaTeX format, this parameter is
ignored, and a pandoc-citeproc style block is used.}
}
\value{
"As is" text of metadata block, with comma-separated list of citation
keys.
}
\description{
Include a metadata block of citation keys for including citations in
references file without in-text citations.
}
\details{
When passed a list of citation keys, adds the @ to each, then builds the
nocite metadata field, returning via "as-is" output. Run this function either
inline or within a code chunk (with \code{echo = FALSE}) to include this
metadata block within an RMarkdown document. The code chunk need not
explicitly state \code{results = 'asis'}.

Call \code{nocite_references} with either \code{style = 'pandoc'} or
\code{style = 'latex'} depending on whether you are processing citations with
pandoc-citeproc or a LaTeX citation processor such as biblatex or natbib.

This function is intended to cite R packages with citation keys passed from
\code{\link[=get_citations]{get_citations()}} or \code{cite_packages(output = "citekeys")},
but can accept an arbitrary vector of citation keys (without @)
found in a BibTeX file referenced in the YAML header.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# include in YAML header:
# bibliography: grateful-refs.bib

# Get citation keys for the current RMarkdown document
# (run after all packages have been loaded).
citekeys <- cite_packages(output = "citekeys", out.dir = tempdir())

# Include in RMarkdown body for use with pandoc-citeproc:
# `r nocite_references(citekeys, citation_processor = 'pandoc')`
\dontshow{\}) # examplesIf}
}
\author{
Connor P. Jackson
}
