% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/year-class.R
\name{year_class}
\alias{year_class}
\alias{year}
\alias{as_year}
\alias{as_year.default}
\alias{as_year.Date}
\alias{as_year.POSIXt}
\alias{as_year.character}
\alias{as_year.factor}
\alias{is_year}
\title{Year class}
\usage{
year(x = integer())

as_year(x, ...)

\method{as_year}{default}(x, ...)

\method{as_year}{Date}(x, ...)

\method{as_year}{POSIXt}(x, ...)

\method{as_year}{character}(x, ...)

\method{as_year}{factor}(x, ...)

is_year(object)
}
\arguments{
\item{x, object}{\R objects.}

\item{...}{Only used For character input where additional arguments are passed through
to \code{as.Date()}.}
}
\value{
A \verb{<grates_year>} object.
}
\description{
Years are represented by a \verb{<grates_year>} object.
}
\details{
\code{year()} takes as input a vector representing, unsurprisingly, the years.
\code{double} vectors are coerced via \code{as.integer(floor(x))}.

\code{as_yearquarter()} is a generic for coercing input in to \verb{<grates_year>}.
\itemize{
\item Character input is first parsed using \code{as.Date()}.
\item POSIXct and POSIXlt are converted with their timezone respected.
}
}
\examples{

# date coercion
as_year(Sys.Date())

# POSIXt coercion
as_year(as.POSIXct("2019-03-04 01:01:01", tz = "America/New_York"))

# Character coercion
as_year("2019-05-03")

# direct construction
year(2011:2020)

}
