% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{partial_residuals}
\alias{partial_residuals}
\alias{partial_residuals.gam}
\title{Partial residuals}
\usage{
partial_residuals(object, ...)

\method{partial_residuals}{gam}(object, select = NULL, partial_match = FALSE, ...)
}
\arguments{
\item{object}{an R object, typically a model. Currently only objects of
class \code{"gam"} (or that inherit from that class) are supported.}

\item{...}{arguments passed to other methods.}

\item{select}{character, logical, or numeric; which smooths to plot. If
\code{NULL}, the default, then all model smooths are drawn. Numeric \code{select}
indexes the smooths in the order they are specified in the formula and
stored in \code{object}. Character \code{select} matches the labels for smooths
as shown for example in the output from \code{summary(object)}. Logical
\code{select} operates as per numeric \code{select} in the order that smooths are
stored.}

\item{partial_match}{logical; should smooths be selected by partial matches
with \code{select}? If \code{TRUE}, \code{select} can only be a single string to match
against.}
}
\description{
Partial residuals
}
\examples{
\dontshow{
op <- options(pillar.sigfig = 4, cli.unicode = FALSE)
}
## load mgcv
load_mgcv()

## example data - Gu & Wabha four term model
df <- data_sim("eg1", n = 400, seed = 42)
## fit the model
m <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = df, method = "REML")

## extract partial residuals
partial_residuals(m)

## and for a select term
partial_residuals(m, select = "s(x2)")

## or with partial matching
partial_residuals(m, select = "x", partial_match = TRUE) # returns all
\dontshow{
options(op)
}
}
