% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{generate.mar}
\alias{generate.mar}
\alias{generate.ets}
\alias{generate.Arima}
\title{Generate a tsibble of synthetic data from a Mixture Autoregressive model}
\usage{
\method{generate}{mar}(x, length = 100, nseries = 10, ...)

\method{generate}{ets}(x, length = 100, nseries = 10, ...)

\method{generate}{Arima}(x, length = 100, nseries = 10, ...)
}
\arguments{
\item{x}{A `mar` object, usually the output of \code{\link{mar_model}()}.}

\item{length}{length of series to generate}

\item{nseries}{number of series to generate}

\item{...}{Other arguments, passed to \code{\link{simulate.mar}}.}
}
\value{
`tsibble` object with `length` rows and 3 columns.
}
\description{
This function simulates multiple random sample paths from a mixture of k Gaussian AR(p) processes.
The model is of the form
\deqn{y_t = \phi_{0,i} + \phi_{1,i}y_{t-1} + \dots + \phi_{p,i}y_{t-p} + \sigma_{i,t}\epsilon_t}
with probability \eqn{\alpha_i}, where \eqn{\epsilon_t} is a N(0,1) variate.
The index of the tsibble is guessed from the MAR model seasonal periods.
}
\examples{
# MAR model with constant variances
phi <- cbind(c(0, 0.8, 0), c(0, 0.6, 0.3))
weights <- c(0.8, 0.2)
model1 <- mar_model(phi = phi, sigmas = c(1, 2), weights = weights)
generate(model1, nseries = 5)
# MAR model for hourly data with daily and weekly periods
hourly_model <- mar_model(seasonal_periods = c(24, 24*7))
generate(hourly_model)
}
\references{
Feng Li, Mattias Villani, and Robert Kohn. (2010). Flexible Modeling of
    Conditional Distributions using Smooth Mixtures of Asymmetric Student T Densities,
    Journal of Statistical Planning and Inference, 140(12), pp. 3638-3654.
}
\seealso{
\code{\link{mar_model}}, \code{\link{simulate.mar}}
}
\author{
Rob J Hyndman
}
