% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModellingSuperannuationChanges.R
\name{model_new_caps_and_div293}
\alias{model_new_caps_and_div293}
\alias{n_affected_from_new_cap_and_div293}
\alias{revenue_from_new_cap_and_div293}
\title{Modelling superannuation changes}
\usage{
model_new_caps_and_div293(
  .sample.file,
  fy.year,
  new_cap = 30000,
  new_cap2 = 35000,
  new_age_based_cap = TRUE,
  new_cap2_age = 49,
  new_ecc = FALSE,
  new_div293_threshold = 3e+05,
  use_other_contr = FALSE,
  scale_contr_match_ato = FALSE,
  .lambda = 0,
  reweight_late_lodgers = TRUE,
  .mu = 1.05,
  impute_zero_concess_contr = TRUE,
  .min.Sw.for.SG = 450 * 12,
  .SG_rate = 0.0925,
  prv_cap = 30000,
  prv_cap2 = 35000,
  prv_age_based_cap = TRUE,
  prv_cap2_age = 49,
  prv_ecc = FALSE,
  prv_div293_threshold = 3e+05
)

n_affected_from_new_cap_and_div293(..., adverse_only = TRUE)

revenue_from_new_cap_and_div293(...)
}
\arguments{
\item{.sample.file}{A \code{data.table} whose variables include those in \code{taxstats::sample_file_1314}.}

\item{fy.year}{The financial year tax scales.}

\item{new_cap}{The \strong{proposed} cap on concessional contributions for all taxpayers if \code{age_based_cap} is FALSE, or for those below the age threshold otherwise.}

\item{new_cap2}{The \strong{proposed} cap on concessional contributions for those above the age threshold. No effect if \code{age_based_cap} is FALSE.}

\item{new_age_based_cap}{Is the \strong{proposed} cap on concessional contributions age-based?}

\item{new_cap2_age}{The age above which \code{new_cap2} applies.}

\item{new_ecc}{(logical) Should an excess concessional contributions charge be calculated? (Not implemented.)}

\item{new_div293_threshold}{The \strong{proposed} Division 293 threshold.}

\item{use_other_contr}{Should \code{MCS_Othr_Contr} be used to calculate Division 293 liabilities?}

\item{scale_contr_match_ato}{(logical) Should concessional contributions be inflated to match aggregates in 2013-14? That is, should the concessional contributions by multiplied by the internal constant \code{grattan:::super_contribution_inflator_1314}, which was defined to be: \deqn{\frac{\textrm{Total assessable contributions in SMSF and funds}}{\textrm{Total contributions in 2013-14 sample file}}}{Total assessable contributions in SMSF and funds / Total contributions in 2013-14 sample file.}.}

\item{.lambda}{Scalar weight applied to \code{concessional contributions}. \eqn{\lambda = 0} means no (extra) weight. \eqn{\lambda = 1} means contributions are inflated by the ratio of aggregates to the sample file's total. For \eqn{R = \textrm{actual} / \textrm{apparent}} then the contributions are scaled by \eqn{1 + \lambda(R - 1)}.}

\item{reweight_late_lodgers}{(logical) Should WEIGHT be inflated to account for late lodgers?}

\item{.mu}{Scalar weight for WEIGHT. (\eqn{w' = \mu w}) No effect if \code{reweight_late_lodgers} is \code{FALSE}.}

\item{impute_zero_concess_contr}{Should zero concessional contributions be imputed using salary?}

\item{.min.Sw.for.SG}{The minimum salary required for super guarantee to be imputed.}

\item{.SG_rate}{The super guarantee rate for imputation.}

\item{prv_cap}{The \strong{comparator} cap on concessional contributions for all taxpayers if \code{age_based_cap} is FALSE, or for those below the age threshold otherwise.}

\item{prv_cap2}{The \strong{comparator} cap on concessional contributions for those above the age threshold. No effect if \code{age_based_cap} is FALSE.}

\item{prv_age_based_cap}{Is the \strong{comparator} cap on concessional contributions age-based?}

\item{prv_cap2_age}{The age above which \code{new_cap2} applies.}

\item{prv_ecc}{(logical) Should an excess concessional contributions charge be calculated? (Not implemented.)}

\item{prv_div293_threshold}{The \strong{comparator} Division 293 threshold.}

\item{...}{Passed to \code{model_new_caps_and_div293}.}

\item{adverse_only}{Count only individuals who are adversely affected by the change.}
}
\value{
For \code{model_new_caps_and_div293}, A data.frame, comprising \code{.sample.file}, the superannuation variables generated by \code{apply_super_caps_and_div293}, and two variables \code{prv_revenue} and \code{new_revenue} which give the tax (income tax, super tax, and division 293 tax) payable by that taxpayer in the comparator scenario and the proposed scenario, respectively.

For \code{n_affected_from_new_cap_and_div293}, the number of individuals affected by the proposed changes.

For \code{revenue_from_new_cap_and_div293}, the extra revenue expected from the proposed changes.
}
\description{
Modelling superannuation changes
}
