% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unemployment_benefit.R
\name{unemployment_benefit}
\alias{unemployment_benefit}
\title{Unemployment benefit}
\usage{
unemployment_benefit(
  income = 0,
  assets = 0,
  fy.year = NULL,
  Date = NULL,
  has_partner = FALSE,
  has_dependant = FALSE,
  is_home_owner = FALSE
)
}
\arguments{
\item{income}{Numeric vector of fortnightly income for the income test.}

\item{assets}{Numeric vector of the value of assets. By default, \code{income} and \code{assets} are both zero, thus returning the maximum benefit payable.}

\item{fy.year}{A character vector of valid financial years between "2000-01" and "2020-21" specifying which financial year the allowance is to be calculated.}

\item{Date}{(Date vector or coercible to such). An alternative to \code{fy.year} to specify the period over which the allowance is calculated.}

\item{has_partner}{(logical vector, default: \code{FALSE}) Does the individual have a partner?}

\item{has_dependant}{(logical vectpr, default: \code{FALSE}) Does the indvidiual have any dependant children?}

\item{is_home_owner}{(logical vector, default: \code{FALSE}) Does the individual own their own home?}
}
\value{
The fortnightly unemployment benefit payable for each entry. 
The function is vectorized over its arguments, with any length-1 argument
recycled. (Other vector recycling is not supported and will result in an error.)
}
\description{
Calculates the unemployment benefit (Newstart Allowance) payable for individuals in the specified financial year(s), 
given each individual's income and assets, and whether they are married, have children, or own their own home.
}
\details{
The income test for long-term employed persons above 60 happens to be the same as 
that for singles with dependants, so calculating the benefit payable for such 
individuals can be performed by setting \code{has_partner = FALSE, has_dependant = TRUE}.
}
