% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpi_inflator_quarters.R
\name{cpi_inflator_quarters}
\alias{cpi_inflator_quarters}
\title{CPI inflator when dates are nice}
\usage{
cpi_inflator_quarters(
  from_nominal_price,
  from_qtr,
  to_qtr,
  adjustment = c("seasonal", "trimmed", "none"),
  useABSConnection = FALSE
)
}
\arguments{
\item{from_nominal_price}{(numeric) the nominal prices to be converted to a real price}

\item{from_qtr}{(date in quarters) the dates contemporaneous to the prices in from_nominal_price. Must be of the form "YYYY-Qq" e.g. "1066-Q2". Q1 = Mar, Q2 = Jun, Q3 = Sep, Q4 = Dec.}

\item{to_qtr}{(date in quarters) the date to be inflated to, where nominal price = real price. Must be of the form "YYYY-Qq" e.g. "1066-Q2".}

\item{adjustment}{Should there be an adjustment made to the index? Adjustments include 'none' (no adjustment), 'seasonal', or 'trimmed' [referring to trimmed mean]. By default, \code{seasonal}.}

\item{useABSConnection}{Should the function connect with ABS.Stat via an SDMX connection? By default set to \code{FALSE} in which case a pre-prepared index table is used. This is much faster and more reliable (in terms of errors), though of course relies on the package maintainer to keep the tables up-to-date.
The internal data was updated on 2021-07-12 to 2021-Q1.
Using \code{useABSConnection = TRUE} is no longer supported for server issues.}
}
\value{
A vector of real prices.
}
\description{
CPI inflator when dates are nice
}
