\name{rectprismgrav}
\alias{rectprismgrav}
\docType{package}
\title{
rectprismgrav
}
\description{
Calculates the graviational attraction of 3-D rectangular prisms.
Calculates anomalies of \code{N} prisms at \code{M} observation stations.

Stations cannot be positioned on the edge of a prism.

Coordinates of stations and prisms are assumed to share a common coordinate system.
}
\usage{
rectprismgrav(xstation, ystation, zstation, xmin, xmax, ymin, ymax,
                         zdeep, zshallow, deltarho, bycell=FALSE)
}
\arguments{
  \item{xstation}{vector of length \code{M} with the x-coordinates of each station, in km, positive east;}
  \item{ystation}{vector of length \code{M} with the y-coordinates of each station, in km, positive north;}
  \item{zstation}{vector of length \code{M} with the z-coordinates of each station, in km, positive up;}
  \item{xmin}{vector of length \code{N} with the minimum x-coordinates of each prism, in km, positive east;}
  \item{xmax}{vector of length \code{N} with the maximum x-coordinates of each prism, in km, positive east;}
  \item{ymin}{vector of length \code{N} with the minimum y-coordinates of each prism, in km, positive north;}
  \item{ymax}{vector of length \code{N} with the maximum y-coordinates of each prism, in km, positive north;}
  \item{zdeep}{vector of length \code{N} with the bottom z-coordinates of each prism, in km, positive up;}
  \item{zshallow}{vector of length \code{N} with the top z-coordinates of each prism, in km, positive up;}
  \item{deltarho}{vector of length \code{N} with the density contrast of each prism, in grams per cubic centimeter (g/cc);}
  \item{bycell}{returns \code{M}-by-\code{N} matrix with anomaly values generated by individual prisms (default FALSE).}
}
\value{
Returns a matrix of length \code{M} rows.

If \code{bycell=FALSE}, there will be \code{M} rows and 1 column, and the
element in the \code{i}-th row represents the total gravity anomaly generated
by all \code{N} prisms as observed at the \code{i}-th station.

If \code{bycell=TRUE}, the matrix will have \code{M} rows and \code{N} columns,
with the element \code{[i,j]} representing the anomaly value generated by the
\code{j}-th prism as observed at the \code{i}-th station.
}
\references{
\itemize{
\item Plouff, D., 1975, Derivation of formulas and FORTRAN programs to compute gravity anomalies of prisms, National Technical Information Service No. PB-243-526, U.S. Department of Commerce, Springfield, VA.  \cr\href{https://ntrl.ntis.gov/NTRL/dashboard/searchResults/titleDetail/PB243526.xhtml}{https://ntrl.ntis.gov/NTRL/dashboard/searchResults/titleDetail/PB243526.xhtml}.
}
}
\seealso{
\command{\link{rectprismmag}},
\code{\link[=gravmagsubs-package]{gravmagsubs}}.
}
\examples{
\donttest{
#########################################################
## gravity anomaly of a single prism at a single point ##

# location of the point where the gravity anomaly will be calculated
gravstation <- data.frame(x=0, y=0, z=0)

# the rectangular prism is defined by its six edges
prism1 <- data.frame(xmin=-5, xmax=5,
                     ymin=-5, ymax=5,
                     zmin=-10, zmax=-5)

# density contrast in g/cc
drho <- 0.3

gravanom <- rectprismgrav(gravstation$x, gravstation$y, gravstation$z,
                          prism1$xmin, prism1$xmax,
                          prism1$ymin, prism1$ymax,
                          prism1$zmin, prism1$zmax, drho)

#########################################################
}
}
