% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{Visualise distances between samples from different time points}
\usage{
plot_heatmap(
  results,
  type = c("registered", "original"),
  match_timepoints = FALSE,
  title = NULL,
  axis_fontsize = NULL
)
}
\arguments{
\item{results}{Results containing distances between two different reference and query data, output of \code{\link{calculate_distance}}.}

\item{type}{Type of plot, determines whether to use "registered" or "original" time points. By default, "registered".}

\item{match_timepoints}{If \code{TRUE}, will match query time points to reference time points.}

\item{title}{Optional plot title.}

\item{axis_fontsize}{Font size of X and Y axes labels.}
}
\value{
Distance heatmap of gene expression profiles over time between two different species.
}
\description{
\code{plot_heatmap()} is a function that allows users to plot distances
between samples from different time points to investigate the similarity of
progression of gene expression states between species before or after
registration.
}
