% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmm.R
\docType{class}
\name{gmm-class}
\alias{gmm-class}
\title{Gaussian mixture model description class}
\description{
An S4 class to represent a multivariate Gaussian mixture  model, extend \code{\link{icl_model-class}}.
The model follow \href{https://tminka.github.io/papers/minka-linear.pdf}{minka-linear} and correspond to the following generative model:
\deqn{ \pi \sim Dirichlet(\alpha)}
\deqn{ Z_i  \sim \mathcal{M}(1,\pi)}
\deqn{ V_k \sim \mathcal{W}^{-1}(\epsilon I,n_0)}
\deqn{ \mu_k \sim \mathcal{N}(0,\frac{V_k}{\tau N})}
\deqn{ X_{i.}|Z_{ik}=1 \sim \mathcal{N}(\mu_k,V_{k})}
}
\section{Slots}{

\describe{
\item{\code{name}}{name of the model}

\item{\code{alpha}}{Dirichlet over cluster proportions prior parameter (default to 1)}

\item{\code{tau}}{Prior parameter (inverse variance) default 0.01}

\item{\code{N0}}{Prior parameter (pseudo count) default to 10 ! should be > number of features}

\item{\code{epsilon}}{Prior parameter co-variance matrix prior}

\item{\code{mu}}{mean prior}
}}

\examples{
new("gmm")
new("gmm",alpha=1,tau=0.1,N0=15)
}
