% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_combinedmodels.R
\docType{class}
\name{CombinedModels}
\alias{CombinedModels}
\alias{CombinedModels-class}
\title{Combined Models classes}
\usage{
CombinedModels(models, alpha = 1)
}
\arguments{
\item{models}{a named list of DlvmPrior's object}

\item{alpha}{Dirichlet prior parameter over the cluster proportions (default to 1)}
}
\value{
a \code{CombinedModels-class} object
}
\description{
An S4 class to represent a combined clustering models, where several models are used to model different datasets. A conditional independence assumption between the view knowing the cluster is made.
}
\details{
The filed name in the models list must match the name of the list use to provide the datasets to cluster together.
}
\examples{
CombinedModels(models = list(continuous = GmmPrior(), discrete = LcaPrior()))
}
\seealso{
\code{\link{CombinedModelsFit-class}}, \code{\link{CombinedModelsPath-class}}

Other DlvmModels: 
\code{\link{DcLbm}},
\code{\link{DcSbm}},
\code{\link{DiagGmm}},
\code{\link{DlvmPrior-class}},
\code{\link{Gmm}},
\code{\link{Lca}},
\code{\link{MoM}},
\code{\link{MoR}},
\code{\link{MultSbm}},
\code{\link{Sbm}},
\code{\link{greed}()}
}
\concept{DlvmModels}
