% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_osm_data.R
\name{get_osm_data}
\alias{get_osm_data}
\title{Download OSM Data}
\usage{
get_osm_data(
  bbox,
  server_url = "https://nominatim.openstreetmap.org/search",
  username = NULL,
  password = NULL
)
}
\arguments{
\item{bbox}{A string representing the bounding box area or the location (e.g., "Lausanne, Switzerland").}

\item{server_url}{Optional string representing an alternative Nominatim server URL.}

\item{username}{Optional string for username if authentication is required for the server.}

\item{password}{Optional string for password if authentication is required for the server.}
}
\value{
A list containing:
\item{highways}{An sf object with the OSM data about highways in the specified location.}
\item{green_areas}{An sf object with the OSM data about green areas, such as parks, forests, gardens, and nature reserves, in the specified location.}
\item{trees}{An sf object with the OSM data about trees in the specified location.}
}
\description{
This function downloads OpenStreetMap (OSM) data for a specified location or bounding box.
The OSM data includes information about highways, green areas, and trees in the specified location.
It requires an internet connection. If using RStudio Cloud, or if you need to use a private
Nominatim server, you can specify an alternative server URL and credentials (username and password).
}
\examples{
\donttest{
  osm_data <- get_osm_data("Lausanne, Switzerland")
}
}
